win32:OS=win32
unix:mac:OS=macosx
unix:!mac:OS=linux

TEMPLATE      = app
LANGUAGE      = C++
OBJECTS_DIR   = temp/obj
MOC_DIR       = temp/moc
DEPENDPATH   += . ..
INCLUDEPATH  += . ..
TARGET        = demoQt4
CONFIG       -= debug_and_release
CONFIG       += qt warn_on release
QT            = core gui

# BASIC EXEMPLE APPLICATION:

HEADERS	    =	MypaintView.h PuMPBrushes.h Tile.h
				
SOURCES	    =	main.cpp MypaintView.cpp PuMPBrushes.cpp

#LIBMYPAINT:

HEADERS += ../mypaint-brush-settings-gen.h \
	../brushsettings-gen.h \
	../mypaint-config.h \
	../helpers.h \
	../mapping.h \
	../mypaint-brush-settings.h \
	../mypaint-brush.h \
	../mypaint-rectangle.h \
	../mypaint-glib-compat.h \
	../mypaint-surface.h \
	../mypaint.h \
	../rng-double.h \
	../fifo.h \
	../operationqueue.h
		   
SOURCES += ../helpers.c \
	../mapping.c \
	../mypaint-brush-settings.c \
	../mypaint-brush.c \
	../mypaint-rectangle.c \
	../mypaint-surface.c \
	../mypaint.c \
	../rng-double.c \
	../fifo.c \
	../operationqueue.c
		   
# Following files are GPL. Should be removed in the future... (You may not include them into a closed source code)
 
HEADERS += ../brushmodes.h ../mypaint-tiled-surface.h
		   
SOURCES += ../brushmodes.c ../mypaint-tiled-surface.c	   
		   
# C-JSON:
win32 {
  # On Windows, we compile the json-c lib directly in the binary.
  # (not possible to simply ask for libjson-dev lib !)
  DEPENDPATH     += json-c
  INCLUDEPATH    += json-c
  QMAKE_CFLAGS   += -TP # TP force MSVC to compile C files of LibMyPaint as C++ files
  QMAKE_CXXFLAGS += -TP
  DEFINES        += NO_GETTEXT
  
  HEADERS +=  json-c/json.h \
	json-c/config.h \
	json-c/json_config.h \
	json-c/arraylist.h \
	json-c/bits.h \
	json-c/debug.h \
	json-c/json_object.h \
	json-c/json_object_private.h \
	json-c/json_tokener.h \
	json-c/json_util.h \
	json-c/linkhash.h \
	json-c/printbuf.h
				
SOURCES +=  json-c/arraylist.c \
	json-c/debug.c \
	json-c/json_object.c \
	json-c/json_tokener.c \
	json-c/json_util.c \
	json-c/linkhash.c \
	json-c/printbuf.c
	
} else {
  # On Linux / Mac, we just link to the correct lib
  LIBS        += -ljson
  INCLUDEPATH += /usr/include/json  # this could be different for your system (try 'whereis json.h')
  # for C files, we need to allow C99 mode.
  QMAKE_CFLAGS += -std=c99
}
